// ===========================================================================
//	LPlacard.cp					PowerPlant 2.2.1	1997-2001 Metrowerks Inc.
// ===========================================================================

#ifdef PowerPlant_PCH
	#include PowerPlant_PCH
#endif

#include "PP_Prefix.h"
#include "UException.h"

#include "LPlacard.h"
#include "UAppearance.h"

PP_Begin_Namespace_PowerPlant


// ---------------------------------------------------------------------------
//	 LPlacard								Stream Constructor		  [public]
// ---------------------------------------------------------------------------

LPlacard::LPlacard(
	LStream*	inStream,
	ClassIDT	inImpID)

	: LControlView(inStream, inImpID)
{
}


// ---------------------------------------------------------------------------
//	 LPlacard								Parameterized Constructor [public]
// ---------------------------------------------------------------------------

LPlacard::LPlacard(
	const SPaneInfo&	inPaneInfo,
	const SViewInfo&	inViewInfo,
	ClassIDT			inImpID)

	: LControlView(inPaneInfo, inViewInfo, inImpID, kControlPlacardProc)
{
}


// ---------------------------------------------------------------------------
//	 ~LPlacard								Destructor				  [public]
// ---------------------------------------------------------------------------

LPlacard::~LPlacard()
{
}


// ---------------------------------------------------------------------------
//	 GetEmbeddedTextColor
// ---------------------------------------------------------------------------
//	Pass back the color for drawing text within the Placard

void
LPlacard::GetEmbeddedTextColor(
	SInt16		inDepth,
	bool		inHasColor,
	bool		inIsActive,
	RGBColor&	outColor) const
{
	ThemeTextColor	color = kThemeTextColorPlacardInactive;
	if (inIsActive) {
		color = kThemeTextColorPlacardActive;
	}

	UAppearance::GetThemeTextColor(color, inDepth, inHasColor,
									inIsActive, &outColor);
}


PP_End_Namespace_PowerPlant
